function output = fct_draw_from_IG_mixture(input)
    % GENERATE A RAMDOM SAMPLE OF INDIVIDUALS
    
    mm_mat = fieldnames(input);
    for i = 1 : length(mm_mat)
        eval([cell2mat(mm_mat(i)) '= input.(cell2mat(mm_mat(i)));']);
    end

    Nmix = length(g_vec);
    tvec = [0:1:TU+1];
    tvals = tvec';
    Nt   = length(tvec);
    Nend = 0;

    for k = 1:length(g_vec)
            mu = mu_vec(k);
            sigma = sigma_vec(k);
            Npeople_k = floor(Npeople*g_vec(k));
            Nstart    = Nend + 1;
            Nend      = Nend + Npeople_k;
    %     if mu > 0     
    %         mu_tilde = 1/mu;
    %         lambda_tilde = 1/sigma^2;
    %         pd = makedist('InverseGaussian','mu',mu_tilde,'lambda',lambda_tilde);
    %         rn = random(pd, [Npeople_k 2]);  
    %         tvec_out(Nstart:Nend,1:2) = rn;
    %     elseif mu < 0
            rn = rand([2*Npeople_k 1]);
            CDFvec = fct_CDF_F_capped(tvec,mu,sigma);
            CDFmat = repmat(CDFvec,2*Npeople_k,1);
            rnmat = repmat(rn,1,Nt);
            index = sum(rnmat>=CDFmat,2);
            tvec_temp = reshape(tvals(index),Npeople_k,2);
            tvec_out(Nstart:Nend,1:2) = tvec_temp;               
        %end

    end
    
    max(tvec_out(:));
    % construct p1 and p2
    NN = length(tvec_out);
    sel_p1 = (tvec_out(:,1)<= TU);
    output.p1 = sum(sel_p1)/NN;

    sel_p2 = (tvec_out(:,1)<=TU) & (tvec_out(:,2)<=TU) ;
    output.p2 = sum(sel_p2)/sum(sel_p1);    

    % output
    tvec_temp = tvec_out(sel_p2,:);
    t1t2_floor = floor(tvec_temp);
    tmin = min(t1t2_floor(:));
    tmax = max(t1t2_floor(:));

    tgrid_out = [0:1:TU];
    [tx ty]   = meshgrid(tgrid_out,tgrid_out);
    data(:,1) = tx(:);
    data(:,2) = ty(:);
    data(:,3) = 0*data(:,2);
    I1        = length(tgrid_out); 
    for i = 1: length(t1t2_floor)
        ki = (t1t2_floor(i,1)-tmin)*I1 + (t1t2_floor(i,2)-tmin+1);
        data(ki,3) = data(ki,3)+1;
    end
    
    % censored second spell
    sel2 = (tvec_out(:,1)<=TU) & (tvec_out(:,2)>TU);
    tvec_temp2 = tvec_out(sel2,:);
    tvec_temp2_floor = floor(tvec_temp2);
    tvec_temp2_floor(:,2) = TU+1;
    second_censored(:,1) = tgrid_out;
    second_censored(:,2) = TU+1;
    second_censored(:,3) = 0;
    for i = 1: length(tvec_temp2_floor)
        ki = tvec_temp2_floor(i,1)-tmin+1;
        second_censored(ki,3) = second_censored(ki,3)+1;
    end
            
    output.data = data;
    output.first_censored = NN - sum(sel_p1);
    output.second_censored = second_censored;    
    
return;


